/*************************************************************************
 * DISCLAIMER *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/
/*************************************************************************************************
 * Copyright (c) 2007, Freescale Semiconductor
 *
 * File name   : Usb_Descriptor.c
 * Project name: JM60 Evaluation code
 *
 * Description : This software evaluates JM60 USB module 
 * History     :
 * 04/01/2007  : Initial Development
 * 
 *************************************************************************************************/
#include "Usb_Descriptor.h"

const USB_DEV_DSC Device_Dsc =
{    
    sizeof(USB_DEV_DSC),    /* Size of this descriptor in bytes     */
    DSC_DEV,                /* DEVICE descriptor type               */
    0x0002,                 /* USB Spec Release Number in BCD format*/
    0xFF,                   /* Class Code                           */
    0x00,                   /* Subclass code                        */
    0x00,                   /* Protocol code                        */
    EP0_BUFF_SIZE,          /* Max packet size for EP0,             */
    0xA215,                 /* Vendor ID    //little-endian for USB */
    0x6000,                 /* Product ID:	//little-endian for USB */
    0x0001,                 /* Device release number in BCD format  */
    0x01,                   /* Manufacturer string index            */
    0x02,                   /* Product string index                 */
    0x00,                   /* Device serial number string index    */
    0x01                    /* Number of possible configurations    */
};

 const USB_CFG  Cfg_01=
 {
    // CONFIGURATION DESCRIPTOR
    {
        sizeof(USB_CFG_DSC),    // Size of this descriptor in bytes
        DSC_CFG,                // CONFIGURATION descriptor type
        (word) ((sizeof(USB_CFG)<<8) | (sizeof(USB_CFG)>>8)),          // Total length of data for this cfg
        1,                      // bNumInterfaces: Number of interfaces in this cfg
        1,                      // bConfigurationValue: Value to use as an argument to select this configuration
        0,                      // iConfiguration: Index of String Desc describing this configuration
        _DEFAULT|_REMOTEWAKEUP, // bmAttributes, see Usb_Config.h
        50                      // bMaxPower. Max power consumption (2X mA)
    },
    // Interface Descriptor 
    {
        sizeof(USB_INTF_DSC),   // Size of this descriptor in bytes
        DSC_INTF,               // INTERFACE descriptor type
        0,                      // Interface Number
        0,                      // Alternate Setting Number
        4,                      // Number of endpoints in this intf
        0xFF,                   // Class code
        0x00,                   // Subclass code
        0x00,                   // Protocol code
        0                       // Interface string index
    },
    
     /* Endpoint Descriptor*/
     /* Size of descriptor
                         Endpoint descriptor identifier
                                 In or Out
                                            Endpoint type
                                                   Max packet size
                                                                          Interval */
    {sizeof(USB_EP_DSC), DSC_EP, _EP01_OUT, _INT,  (word)(UEP1_SIZE << 8), 32},
    {sizeof(USB_EP_DSC), DSC_EP, _EP02_IN,  _INT,  (word)(UEP2_SIZE << 8), 32},
    {sizeof(USB_EP_DSC), DSC_EP, _EP03_OUT, _BULK, (word)(UEP3_SIZE << 8), 0},
    {sizeof(USB_EP_DSC), DSC_EP, _EP04_IN,  _BULK, (word)(UEP4_SIZE << 8), 0}
};

struct
{
  byte bLength;
  byte bDscType;
  word string;
} const sd000 
= {sizeof(sd000),DSC_STR,0x0904};

struct
{
  byte bLength;
  byte bDscType;
  byte string[sizeof("Samuel Inc")*2];
} const sd001
  ={
    sizeof(sd001),DSC_STR,
    'S',0,
    'a',0,
    'm',0,
    'u',0,
    'e',0,
    'l',0,
    ' ',0,
    'I',0,
    'n',0,
    'c',0
   }; 
       

struct
{
  byte bLength;
  byte bDscType;
  byte string[sizeof("Smart Card Reader")*2];
} const sd002
  ={
    sizeof(sd002),DSC_STR,
    'S',0,
    'm',0,
    'a',0,
    'r',0,
    't',0,
    ' ',0,
    'C',0,
    'a',0,
    'r',0,    
    'd',0,
    ' ',0,
    'R',0,
    'e',0,
    'a',0,
    'd',0,
    'e',0,
    'r',0
   }; 

    
unsigned char* Str_Des[] = 
    { (unsigned char*)&sd000,(unsigned char*)&sd001,(unsigned char*)&sd002};   

unsigned char* Cfg_Des[] =
    {(unsigned char*)&Cfg_01,(unsigned char*)&Cfg_01 };
    
pFunc Std_Class_Req_Handler[1] = { NULL };


